function [x,y] = coordinates_snowflake(x_cen, y_cen, r, w)

x_ini = [x_cen+w/2*sqrt(3) x_cen+r x_cen+r];
y_ini = [y_cen+w/2 y_cen+w/2 y_cen-w/2];
angle = -60;

[x_rot1, y_rot1] = rotate(x_ini, y_ini, x_cen, y_cen, angle);
[x_rot2, y_rot2] = rotate(x_ini, y_ini, x_cen, y_cen, 2*angle);
[x_rot3, y_rot3] = rotate(x_ini, y_ini, x_cen, y_cen, 3*angle);
[x_rot4, y_rot4] = rotate(x_ini, y_ini, x_cen, y_cen, 4*angle);
[x_rot5, y_rot5] = rotate(x_ini, y_ini, x_cen, y_cen, 5*angle);

x = horzcat(x_ini, x_rot1, x_rot2, x_rot3, x_rot4, x_rot5, x_ini(1));
y = horzcat(y_ini, y_rot1, y_rot2, y_rot3, y_rot4, y_rot5, y_ini(1));

end